﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Kasa" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<TITLE>Kontrahent</TITLE>
		<script runat="server">
		
		void OnContextLoad(Object sender, EventArgs args)
		{
			if (!dc.Context.Contains(typeof(RozrachunkiPodmiotuPageParams)))
				throw new BusException("Wydruk musi być wołany z listy rozrachunków na formularzu kontrahenta");
			RozrachunkiPodmiotuPageParams pars = (RozrachunkiPodmiotuPageParams)dc[typeof(RozrachunkiPodmiotuPageParams)];
			
			ReportHeader["INDEKS"] = pars.Indeks.ToString();
			ReportHeader["DOKUMENTY"] = pars.Dokumenty.ToString();
			
            KasaModule kasa = KasaModule.GetInstance(dc);
            Soneta.Business.View view;

            switch (pars.Indeks) {
                case TypRozIndeksu.Rozliczone:
                    view = kasa.RozrachunkiIdx.Rozliczone(pars.Podmiot, pars.Okres, pars.Aktualny);
                    break;
                case TypRozIndeksu.Nierozliczone:
                    view = kasa.RozrachunkiIdx.Nierozliczone(pars.Podmiot, pars.Okres, pars.Aktualny);
                    break;
                default:
                    view = kasa.RozrachunkiIdx.Wszystkie(pars.Podmiot, pars.Okres* new FromTo(Date.MinValue, pars.Aktualny));
                    break;
            }
            
            switch (pars.Dokumenty) {
                case TypRozDokumentów.Należności:
                    view.Condition &= kasa.RozrachunkiIdx.NaleznosciEx();
                    break;
                case TypRozDokumentów.Zobowiązania:
                    view.Condition &= kasa.RozrachunkiIdx.ZobowiazaniaEx();
                    break;
            }

            Grid1.DataSource = view;			
		}		
		
		</script>
	</HEAD>
	<BODY>
		<FORM method="post" runat="server">
			<ea:DataContext id="dc" OnContextLoad="OnContextLoad" runat="server" TypeName="Soneta.CRM.Kontrahent,Soneta.CRM" />
			<eb:ReportHeader id="ReportHeader" runat="server" title="{0}|</strong>Indeks: <strong>%INDEKS%|</strong>Dokumenty: <strong>%DOKUMENTY%" DataMember0="." />
			<ea:Grid runat="server" RowTypeName="Soneta.Kasa.RozrachunekIdx,Soneta.Kasa" id="Grid1">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." />
					<ea:GridColumn Width="20" Align="Left" DataMember="Numer" Total="Info" Caption="Numer" />
					<ea:GridColumn Width="10" Align="Center" DataMember="Data" />
					<ea:GridColumn Width="10" Align="Center" DataMember="Termin" />
					<ea:GridColumn Width="5" Align="Right" DataMember="Workers.Info.Pozostaje" Caption="Pozostaje" HideZero="True" />
					<ea:GridColumn Width="5" Align="Right" DataMember="Workers.Info.Zwłoka" Caption="Zwłoka" HideZero="True" />
					<ea:GridColumn Width="15" Align="Right" DataMember="Workers.Info.Należność" Total="Sum" Caption="Należności" HideZero="True" />
					<ea:GridColumn Width="15" Align="Right" DataMember="Workers.Info.Zobowiązanie" Total="Sum" Caption="Zobowiązania" HideZero="True" />
					<ea:GridColumn Align="Left" DataMember="Dokument.Opis" Caption="Opis" />
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</FORM>
	</BODY>
</HTML>

